<?php
define("IN_MYBB", true);
include("global.php");
include("inc/Sajax.php");
require_once('inc/class_parser.php');
$small = isset($_GET["small"]);
$tbl = 'ajaxchat';
function sendChat($message)
{
	global $tbl, $mybb, $db;
	if(!empty($message) && $mybb->user['uid'] > 0)
		$db->insert_query($tbl, array('uid' => $mybb->user['uid'], 'message' => $db->escape_string($message), 'date' => time()));
}
function getChats($id, $limit=20)
{
	global $tbl, $mybb, $db;
	$result = $db->simple_select($tbl, '*', 'id > "'.($db->escape_string($id)).'"', array('order_by' => 'id', 'order_dir' => 'desc', 'limit' => ($db->escape_string($limit))));
	$id = $db->fetch_field($db->simple_select($tbl, 'id', '', array('order_by' => 'id', 'order_dir' => 'desc', 'limit' => 1)), 'id');
	$arr = array($id, $db->num_rows($result) + 2);
	$parser = new postParser();
	while($row = $db->fetch_array($result))
	{
		$date = date('n/j/y G:i', $row["date"]);
		$user = $db->fetch_array($db->simple_select('users', 'username, avatar', 'uid="'.$row["uid"].'"'));
		if($user["avatar"] == "")
			$user["avatar"] = "images/default_avatar.gif";
		$name = $user["username"];
		$msg = $parser->parse_message($row["message"], array('filter_badwords'=>1, 'allow_mycode'=>1, 'allow_smilies'=>1, 'me_username'=>1, 'nl2br'=>0));
		$arr[] = '<table><tr><td class="left"><img src="'.$user["avatar"].'" width="25" class="char"/><a href="'.get_profile_link($row["uid"]).'" target="_top">'.$name.'</a><br/>'.$date.'</td><td>'.$msg.'</td></tr></table>';
	}
	return $arr;
}
function getChat($id)
{
    return getChats($id, 1);
}
sajax_init();
sajax_export("sendChat");
sajax_export("getChats");
sajax_export("getChat");
sajax_handle_client_request();
?>
<html>
<head>
<link rel="stylesheet" href="ajaxchat.css"/>
<title>MyBB AJAX Chat</title>
<script type="text/javascript">
<?php sajax_show_javascript(); ?>
</script>
<?php
if($small)
	echo '<script type="text/javascript" src="ajaxchat_small.js" />';
else
	echo '<script type="text/javascript" src="ajaxchat.js" />';
?>
</script>
</head>
<body>
<?php
$id = "x";
if(!$small)
{
$id = "chat_table";
?>
<div id="container">
<table width="100%" cellpadding="0" cellspacing="0" style="padding-top:10px;">
<tr>
<td>

<div id="chat_border">
<?php
}
?>
<div id="<?php echo $id; ?>">
<div id="chat">
</div>
</div>
<?php
if(!$small)
{
?>
</div>
</td>
</tr>
<?php
}
if(!$small && $mybb->user['uid'] > 0)
{
?>
<tr><td class="spacer"></td></tr>
<tr><td colspan="2" class="sendbar"><form action="chat_frame.php" onsubmit="javascript:sendChat(); return false;"><input type="text" id="message" size="90" maxlength="128" value=""/> <a href="#send" id="chatbutton" onclick="sendChat()">ارسال</a></form></td></tr>
</table>
<a name="send"></a>
</div>
<?php
}
?>
</body>
</html>